package fr.asip.cps3.exemple.vues.ecrans.saisie;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.modele.objets.Algo;
import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de saisie d'un Fichier
 */
public class SaisieFichier extends Saisie implements ActionListener {

	/**
	 * Algorithme  prendre en compte pour l'opration
	 */
	protected Algo algo;
	
	/**
	 * Libell Fichier 
	 */
	protected JLabel libelleFichier;
	
	/**
	 * Texte Fichier
	 */
	protected JTextField texteFichier;
	
	/**
	 * Bouton parcourir
	 */
	protected JButton boutonParcourir;
	
	/**
	 * Constructeur  3 arguments
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param Type d'cran
	 * @param Algorithme  prendre en compte pour l'opration
	 */
	public SaisieFichier(FenetrePrincipale fenetre, int typeEcran, Algo algo) {

		super(fenetre,typeEcran);
		this.algo = algo; 
		libelleFichier = new JLabel("Choisisser un fichier :");
		texteFichier = new JTextField(32);
		boutonParcourir = new JButton("Parcourir ...");
		boutonParcourir.addActionListener(this);
    	
	}

	/**
     * Renvoie le fichier
     * @return Fichier
     */
	public String getFichier() {
		if(texteFichier != null)
			return texteFichier.getText();
		return null;
	}

	/**
     * Accesseur
     * @return Algorithme associ  l'cran de saisie
     */
	public Algo getAlgo() {
		return algo;
	}
	
	/**
	 * Affiche les champs d'entre
	 * @param fenetre La fentre qui doit contenir l'cran d'entre
	 */
    public void affiche() {

    	JFrame fenetre = this.fenetre.getFenetre();
    	
    	if(fenetre != null && fenetre.getContentPane() != null) {
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	    	
	        // Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleFichier, EcranUtil.styleLibelleSaisieFichier, 0, 0, 1, 1);
	        g.ajoute(texteFichier, EcranUtil.styleChampTexteFichier, 0, 1, 1, 1);
	        g.ajoute(boutonParcourir, EcranUtil.styleBoutonParcourir, 0, 2, 1, 1);
	        // Ligne 1
	        g.ajoute(soumettre, EcranUtil.styleBoutonSoumettre, 1, 0, 1, 3);
	        // Ligne 2
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 2, 0, 1, 3);
	        
    	}
    }

    /**
     * Intercepte la demande de recherche de fichier
     */
	public void actionPerformed(ActionEvent e) {
		
		JFrame fenetre = this.fenetre.getFenetre();
		// Chargement du fichier
		JFileChooser fc = new JFileChooser();
        int valeurRetour = fc.showOpenDialog(fenetre);
        
        if (valeurRetour == JFileChooser.APPROVE_OPTION) {
            File fichier = fc.getSelectedFile();
            if(fichier != null)
            	texteFichier.setText(fichier.getAbsolutePath());
        }
        
	}
}
